PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144441305"
 Author = "jayas.jayas"
 Desc = "Single Transmission Line (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144440564
  Nodes = 
   {
   Input("FType",36,-18)
    {
    Type = Integer
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([72,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,198,198,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(39811736)
    Dial(39871152)
    Slider(39406680)
    Slider(39408768)
    Slider(39824808)
    }
   -Wire-([1116,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datamerge([1044,1098],4,0,180)
    {
    N = "2"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1026,1026],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1026,1044],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([990,684],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([990,738],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([990,792],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([954,684],0,39285144,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var([954,738],0,39286416,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.4"
    Units = "s"
    Collect = "1"
    }
   0.var([954,792],0,39288392,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([954,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,198,1062,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1116,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([990,846],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1062,684],4,0,110)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -ControlPanel-([954,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39342216)
    Slider(39285144)
    Slider(39286416)
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,756],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,828],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([792,792],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([990,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([990,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([954,846],0,39318424,80)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.4"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([954,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39345624)
    Slider(39288392)
    Slider(39318424)
    }
   0.tbreakn([1062,864],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1116,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1152,864],6,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1080,774],0,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1080,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1080,1188],0,0,100)
    {
    Name = "FType"
    }
   0.logic([1152,684],0,0,120)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1188,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1188,648],0,39342216,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1296,684],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1188,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([972,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,954,1080,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([954,540],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,540,1116,612
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1188,810],6,39345624,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1224,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1296,828],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1260,828],0,0,160)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1260,684],6,0,130)
    {
    Type = "2"
    Inv = "0"
    }
   0.export([1080,1080],4,0,190)
    {
    Name = "B"
    }
   0.tfaultn([756,792],4,0,140)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([486,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,108,648,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([486,216],1,0,-1)
    {
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(39820032)
    Meter(39857912)
    Meter(39865040)
    Slider(39822016)
    Meter(39890552)
    Meter(39850120)
    Meter(39851936)
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(39816088)
    Meter(39867032)
    Meter(39869024)
    Slider(39818048)
    Meter(39729024)
    Meter(39853928)
    Meter(39855920)
    }
   0.var([594,756],0,39406680,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.22"
    Units = "s"
    Collect = "1"
    }
   0.var([594,828],0,39408768,60)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = ""
    Collect = "1"
    }
   -Sticky-([252,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,864,378,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no fault
11=> No fault  (0)"
    }
   -Sticky-([738,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,108,846,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Sticky-([738,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,450,900,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT 
          record data.

You can turn on or off
each recorder individually."
    }
   -ControlPanel-([756,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(39883696)
    Switch(39885440)
    }
   -ControlPanel-([756,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(39879216)
    Slider(39722056)
    }
   0.export([1080,1134],4,0,170)
    {
    Name = "F"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2:
          Between Line1
          and  B1
  3=> FT3:
          Midpoint on Line1
  4=> FT4:
          Between Line1
          and B2
  5=> FT5:
          Between Source
          and B2"
    }
   -Divider-([936,90],0)
    {
    Size(0,1098)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([18,630],0)
    {
    Size(918,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([702,90],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots")
  {
  Desc = ""
  FileDate = 1144440564
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,90],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,504,1098]
    Posn = [18,90]
    Icon = [-1,-1]
    Extents = 0,0,504,1098
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,264],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39727032,"V1",0,,,)
     }
    Graph([0,264],[0,0,504,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39724904,"I1",0,,,)
     }
    Graph([0,527],[0,0,504,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39801728,"I10",0,,,)
     }
    PGraph([0,790],[0,0,504,245],"PolyGraph")
     {
     Options = 2
     Curve(39690144,"Br1b",1,,,1)
     Curve(39719096,"Br1c",2,,,1)
     Curve(39675136,"Br1a",0,,,1)
     }
    }
   -Plot-([540,90],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,504,1098]
    Posn = [540,90]
    Icon = [-1,-1]
    Extents = 0,0,504,1098
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,264],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39671352,"V2",0,,,)
     }
    Graph([0,264],[0,0,504,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39669432,"I2",0,,,)
     }
    Graph([0,527],[0,0,504,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39804256,"I20",0,,,)
     }
    PGraph([0,790],[0,0,504,245],"PolyGraph")
     {
     Options = 2
     Curve(39686552,"Br2a",0,,,1)
     Curve(39692048,"Br2b",1,,,1)
     Curve(39688240,"Br2c",2,,,1)
     }
    }
   -Plot-([1062,36],0)
    {
    Title = "Current"
    Draw = 1
    Area = [0,0,504,558]
    Posn = [1062,36]
    Icon = [-1,-1]
    Extents = 0,0,504,558
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,248],"Current Magnitude")
     {
     Options = 9
     Units = ""
     Curve(39928648,"Ia1Mag",0,,,)
     Curve(39961024,"Ib1Mag",1,,,)
     Curve(39972544,"Ic1Mag",2,,,)
     }
    Graph([0,248],[0,0,504,247],"Current Phase")
     {
     Options = 9
     Units = ""
     Curve(39931008,"Ia1Ph",0,,,)
     Curve(39942016,"Ib1Ph",1,,,)
     Curve(39955824,"Ic1Ph",2,,,)
     }
    }
   -Plot-([1062,630],0)
    {
    Title = "Voltages"
    Draw = 1
    Area = [0,0,504,558]
    Posn = [1062,630]
    Icon = [-1,-1]
    Extents = 0,0,504,558
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,248],"Voltage Magnitude")
     {
     Options = 9
     Units = ""
     Curve(39978200,"Va1Mag",0,,,)
     Curve(39958416,"Vb1Mag",1,,,)
     Curve(39970144,"Vc1Mag",2,,,)
     }
    Graph([0,248],[0,0,504,247],"Voltage Phase")
     {
     Options = 9
     Units = ""
     Curve(39968152,"Va1Ph",0,,,)
     Curve(39975944,"Vb1Ph",1,,,)
     Curve(39952584,"Vc1Ph",2,,,)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144440564
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([414,522],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([216,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([396,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([738,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([918,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([954,1008],2,0,-1)
    {
    Name = "I1A"
    }
   0.pgb([1062,1080],0,39669432,670)
    {
    Name = "I2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1062,972],0,39671352,260)
    {
    Name = "V2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-500.0"
    Max = "400.0"
    }
   0.datalabel([1152,918],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1152,954],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1152,990],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1188,918],0,39675136,840)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1278,918],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1278,954],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1314,918],0,39686552,830)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1314,990],0,39688240,780)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1188,954],0,39690144,820)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1314,954],0,39692048,800)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([558,792],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([594,792],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([630,792],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([558,1008],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([594,1008],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([630,1008],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([1026,936],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([450,792],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([486,792],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([522,792],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([450,1008],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([486,1008],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([522,1008],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([270,396],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([378,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([360,900],0,0,-1)
    {
    Vertex="0,0;0,216"
    }
   -Wire-([360,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1152,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1116],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1152,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1152],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1278,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1152],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1026,972],2,0,-1)
    {
    Name = "V2"
    }
   0.datalabel([1278,1116],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1278,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1080],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1278,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1044],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1278,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,990],0,0,-1)
    {
    Name = "Br2C"
    }
   -Wire-([1026,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([522,1008],0,0,240)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([486,1008],0,0,230)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1026,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1080],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1188,990],0,39719096,790)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([450,1008],0,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([504,990],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.var([324,900],0,39722056,140)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1368,36],2,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1368,36],6,0,-1)
    {
    Name = "B2"
    }
   0.pgb([1062,1026],0,39724904,760)
    {
    Name = "I1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1062,936],0,39727032,180)
    {
    Name = "V1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-500.0"
    Max = "400.0"
    }
   0.pgb([1314,864],0,39729024,160)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1332,36],2,0,410)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([234,522],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([774,846],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([810,846],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([234,540],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([774,1098],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1332,36],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1350,108],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([828,1008],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([414,540],0,0,-1)
    {
    Name = "F2"
    }
   -Wire-([1026,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1026,1116],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([1062,1116],0,39801728,630)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.datalabel([1026,1152],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1062,1152],0,39804256,590)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.datatap([774,846],6,0,920)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([846,846],6,0,900)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([882,846],6,0,890)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([846,846],2,0,-1)
    {
    Name = "FT3"
    }
   0.datatap([774,1098],0,0,710)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([846,1098],0,0,690)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,1098],0,0,-1)
    {
    Name = "F2"
    }
   0.datatap([810,1098],0,0,700)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([846,1098],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([720,972],0,39811736,190)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([792,972],0,0,200)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([828,972],4,0,370)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([792,936],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([828,936],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([828,972],5,0,-1)
    {
    Name = "FType"
    }
   0.var([990,468],5,39816088,60)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "0"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1044,468],5,39818048,70)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([144,468],3,39820032,50)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([90,468],3,39822016,40)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.tpflt([378,504],0,0,1010)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var([756,1170],0,39824808,280)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   -Sticky-([954,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,810,1062,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.recorder2_0([522,1080],0,0,750)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([630,936],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([630,1152],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([756,1152],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([414,990],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([504,774],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.datatap([450,792],0,0,90)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([414,774],2,0,-1)
    {
    Name = "V1"
    }
   0.datatap([522,792],0,0,120)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([486,792],0,0,100)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([198,504],0,0,1020)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([792,1170],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([846,1170],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([756,504],4,0,990)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([720,540],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([720,522],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([900,540],0,0,-1)
    {
    Name = "F5"
    }
   0.tpflt([936,504],4,0,980)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([900,522],0,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([810,900],0,0,860)
    {
    DPath = "0"
    }
   -Wire-([756,864],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([810,846],6,0,910)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([918,846],6,0,880)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([882,846],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([918,846],2,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([810,1044],6,0,500)
    {
    DPath = "0"
    }
   0.datatap([882,1098],0,0,680)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([756,1080],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([918,1098],0,0,660)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([882,1098],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([918,1098],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1152,1044],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1188,1044],0,39850120,740)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1188,1080],0,39851936,650)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1044],0,39853928,720)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1080],0,39855920,640)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1188,1116],0,39857912,610)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1188,1152],0,39865040,580)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1116],0,39867032,600)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1152],0,39869024,570)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.var_pot([900,972],2,39871152,250)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.recorder2_0([522,864],0,0,930)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([144,828],1,0,110)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([180,864],6,0,340)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([126,1044],1,0,220)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([36,900],0,39879216,130)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([378,864],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.select([162,1080],6,0,270)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([378,1080],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([72,1116],0,0,-1)
    {
    Vertex="0,0;0,-216"
    }
   -Wire-([360,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([360,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([72,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([72,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([180,792],1,39883696,80)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([162,1008],1,39885440,170)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1350,72],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1350,54],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1422,72],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1422,108],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.breaker3([828,396],0,0,430)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.835 [MW]"
    Q = "-0.6378 [MVAR]"
    }
   -Wire-([864,396],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([1188,864],0,39890552,150)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.source3R([126,396],6,0,290)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.breaker3([306,396],4,0,440)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.809 [MW]"
    Q = "-0.6734 [MVAR]"
    }
   0.source3R([1008,396],2,0,300)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datalabel([540,540],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([540,522],0,0,-1)
    {
    Name = "FT3"
    }
   0.tpflt([576,504],4,0,1000)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1296,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1368,378],2,0,-1)
    {
    Name = "VPM"
    }
   0.datalabel([1404,378],2,0,-1)
    {
    Name = "VNM"
    }
   0.datalabel([1440,378],2,0,-1)
    {
    Name = "VZM"
    }
   0.datalabel([1512,414],6,0,-1)
    {
    Name = "VPP"
    }
   -Wire-([1512,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1512,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1512,486],6,0,-1)
    {
    Name = "VZP"
    }
   -Wire-([1512,486],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1296,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1296,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1368,198],2,0,-1)
    {
    Name = "IPM"
    }
   0.datalabel([1404,198],2,0,-1)
    {
    Name = "INM"
    }
   0.datalabel([1440,198],2,0,-1)
    {
    Name = "IZM"
    }
   0.datalabel([1512,234],6,0,-1)
    {
    Name = "IPP"
    }
   -Wire-([1512,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1512,270],6,0,-1)
    {
    Name = "INP"
    }
   -Wire-([1512,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1512,306],6,0,-1)
    {
    Name = "IZP"
    }
   -Wire-([1512,306],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1512,450],6,0,-1)
    {
    Name = "VNP"
    }
   0.datalabel([1296,414],2,0,-1)
    {
    Name = "V1a"
    }
   0.datalabel([1296,486],2,0,-1)
    {
    Name = "v1c"
    }
   0.datalabel([1296,450],2,0,-1)
    {
    Name = "V1b"
    }
   0.datalabel([1296,234],2,0,-1)
    {
    Name = "I1a"
    }
   0.datalabel([1296,270],2,0,-1)
    {
    Name = "I1b"
    }
   0.datalabel([1296,306],2,0,-1)
    {
    Name = "I1c"
    }
   0.datatap([1458,612],3,0,320)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,720],3,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1404,738],2,0,-1)
    {
    Name = "IPM"
    }
   -Wire-([1404,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,684],2,0,-1)
    {
    Name = "VPP"
    }
   0.datatap([1458,756],3,0,530)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1404,774],2,0,-1)
    {
    Name = "IPP"
    }
   -Wire-([1404,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,612],6,0,-1)
    {
    Name = "Va1mag1"
    }
   0.datalabel([1404,630],2,0,-1)
    {
    Name = "VPM"
    }
   0.datalabel([1458,666],6,0,-1)
    {
    Name = "Va1Phase60"
    }
   -Wire-([1458,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1458,666],3,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1494,720],0,39928648,950)
    {
    Name = "Ia1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.2"
    }
   0.datalabel([1458,756],6,0,-1)
    {
    Name = "Ia1phase60"
    }
   0.pgb([1494,756],0,39931008,940)
    {
    Name = "Ia1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datatap([1458,828],3,0,350)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,936],3,0,520)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,972],3,0,510)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1404,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1458,882],3,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,846],2,0,-1)
    {
    Name = "VnM"
    }
   0.datalabel([1404,900],2,0,-1)
    {
    Name = "VnP"
    }
   0.datalabel([1404,954],2,0,-1)
    {
    Name = "InM"
    }
   0.datalabel([1404,990],2,0,-1)
    {
    Name = "InP"
    }
   0.datalabel([1458,828],6,0,-1)
    {
    Name = "Vb1mag1"
    }
   0.datalabel([1458,882],6,0,-1)
    {
    Name = "Vb1Phase60"
    }
   0.datalabel([1458,936],6,0,-1)
    {
    Name = "Ib1mag1"
    }
   0.datalabel([1458,972],6,0,-1)
    {
    Name = "Ib1phase60"
    }
   0.pgb([1494,972],0,39942016,770)
    {
    Name = "Ib1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datatap([1458,1026],3,0,380)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1404,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1458,1170],3,0,460)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1404,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1458,1080],3,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1170],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1044],2,0,-1)
    {
    Name = "VZM"
    }
   0.datalabel([1404,1098],2,0,-1)
    {
    Name = "VZP"
    }
   0.datalabel([1404,1152],2,0,-1)
    {
    Name = "IZM"
    }
   0.datalabel([1404,1188],2,0,-1)
    {
    Name = "IZP"
    }
   0.datalabel([1458,1026],6,0,-1)
    {
    Name = "VC1mag1"
    }
   0.datalabel([1458,1080],6,0,-1)
    {
    Name = "Vc1Phase60"
    }
   0.pgb([1494,1080],0,39952584,620)
    {
    Name = "Vc1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datalabel([1458,1134],6,0,-1)
    {
    Name = "Ic1mag1"
    }
   0.datalabel([1458,1170],6,0,-1)
    {
    Name = "Ic1phase60"
    }
   0.pgb([1494,1170],0,39955824,550)
    {
    Name = "Ic1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datalabel([1458,720],6,0,-1)
    {
    Name = "Ia1mag1"
    }
   0.pgb([1494,828],0,39958416,870)
    {
    Name = "Vb1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "160.0"
    }
   0.datatap([1458,1134],3,0,470)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1494,936],0,39961024,810)
    {
    Name = "Ib1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.2"
    }
   0.pgb([1494,666],0,39968152,960)
    {
    Name = "Va1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1494,1026],0,39970144,730)
    {
    Name = "Vc1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "160.0"
    }
   -Wire-([1404,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1494,1134],0,39972544,560)
    {
    Name = "Ic1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.2"
    }
   0.fft([1404,270],0,0,450)
    {
    Type = "3"
    Size = "0"
    F = "$(f)"
    AMod = "0"
    PMod = "1"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.fft([1404,450],0,0,310)
    {
    Type = "3"
    Size = "0"
    F = "$(f)"
    AMod = "0"
    PMod = "1"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.pgb([1494,882],0,39975944,850)
    {
    Name = "Vb1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1494,612],0,39978200,970)
    {
    Name = "Va1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "160.0"
    }
   -Wire-([558,450],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([756,396],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([378,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,432,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line
   divide into 2 line sections, T1 and T2.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Five fault positions for full fault control ahead and behind station relays and Mid line
- Two breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   0.pi_section2([558,396],0,0,-1)
    {
    Name = "Line1"
    PU = "1"
    F = "$(f)"
    len = "100.0 [km]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "3.57448095e-5 [ohm/m]"
    Xp = "5.07762676e-4 [ohm/m]"
    Bp = "3.27117946e-9 [mho/m]"
    Rz = "3.63152201e-4 [ohm/m]"
    Xz = "1.32647323e-3 [ohm/m]"
    Bz = "2.32266098e-9 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   -Sticky-([972,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,486,1062,522
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([72,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,486,162,522
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Plots([1512,90],0,0,10)
    {
    }
   .Controls([1458,90],4,0,400)
    {
    }
   -Sticky-([522,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 522,36,918,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz,  select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([18,720],0)
    {
    Size(1224,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([360,396],0,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([774,396],4,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datamerge([1026,1026],3,0,490)
    {
    N = "3"
    Type = "2"
    Disp = "0"
    }
   0.datalabel([972,1008],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([990,1008],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([954,1062],2,0,-1)
    {
    Name = "I2A"
    }
   0.datamerge([1026,1080],3,0,480)
    {
    N = "3"
    Type = "2"
    Disp = "0"
    }
   0.datalabel([972,1062],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([990,1062],2,0,-1)
    {
    Name = "I2C"
    }
   -Divider-([1242,36],0)
    {
    Size(0,684)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.datalabel([1152,864],2,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1152,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,864],2,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1278,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 }

